/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{  Copyright (c) 2003-2005 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Specialized;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Handles;
using Borland.Eco.Services;

namespace Borland.Data.Web.Eco
{
   #region EcoPageStateManager
   public class EcoPageStateManager
   {
       private const string AtSysError = " at System.";
	   private Page page;
	   private EcoDataSource dataSource;
	   private IDBDataSource iDataSource;
	   private string fullPageName;
	   private IEcoPageStateManager dataSourceAccess;
		// last row here means the row that was current prior to
		// current scrolling, and does NOT mean the last row of
	   // the table.  The last row of the table is RowCount!
	   private int [] FLastRow;
	   private int [] FRowCount;
		// Current physical row position for all tables in dataset unadjusted for
	   private int [] FCurrentRow;
		// Keep track of deleted records not sent to server for undo purposes
		// store current row when DataSet is not yet available
	   private int FCurrentRowHolder;
	   // These contain values set with RegisterHidden Fields as
	   // well as any values from SUBMIT field on page
	   private ArrayList FErrors;
	   private ArrayList FWarnings;
	   private ArrayList FDuplicateColumns;
	   private NameValueCollection postCollectionValues;
	   private NameValueCollection tableChanges;
	   public ClientAction clientAction;
	   private int FRowChangeController;
	   private bool FHiddenRowsSet;
	   private bool FPostCollectionValuesSet;
	   private string FAspGridId;


	  public EcoPageStateManager(Page p, EcoDataSource ds, string gridIdentifier)
	  {
		page = p;
		if( !ClassUtils.IsDesignTime(page) )
			fullPageName = ClassUtils.GetPageName(p);
		else
			fullPageName = "";
		dataSource = ds;
		dataSourceAccess = ds as IEcoPageStateManager;
		iDataSource = (ds as IDBDataSource);
		FCurrentRow = null;
		clientAction = ClientAction.ecaNone;
		postCollectionValues = new NameValueCollection();
		tableChanges = new NameValueCollection();
		FCurrentRowHolder = 0;
		FErrors = new ArrayList();
		FWarnings = new ArrayList();
		FDuplicateColumns = new ArrayList();
		if( !ClassUtils.IsDesignTime(page) && !ds.AutoUpdate)
			if( page.Session[iDataSource.GetDataSourceName(page) + DBWebConst.sDataSource] == null && ds.DataSource != null )
			   page.Session[iDataSource.GetDataSourceName(page) + DBWebConst.sDataSource] = ds.DataSource;
		FAspGridId = gridIdentifier;
	  }

		public void SetTableOrView( string DataMember, Object o )
		{
		}

		public ElementHandle EcoHandle(string DataMember)
		{
			return iDataSource.GetTableOrView(page, DataMember) as ElementHandle;
		}

		protected void SetInsertState(string DataMember, InsertState value)
		{
			page.Session[fullPageName + DataMember + DBWebConst.sInsertingRow] = value;
		}

		protected InsertState GetInsertState(string DataMember)
		{
			Object insertState = page.Session[fullPageName + DataMember + DBWebConst.sInsertingRow];
			if( insertState == null )
				return InsertState.InsertNone;
			else if( Convert.ToInt32(insertState) == Convert.ToInt32(InsertState.InsertStart) )
				return InsertState.InsertStart;
			else if( Convert.ToInt32(insertState) == Convert.ToInt32(InsertState.InsertEnd) )
				return InsertState.InsertEnd;
			return InsertState.InsertNone;
		}

      public bool IsInsertingRow()
      {
         return false;
      }

		public bool IsInsertingRow(string DataMember)
		{
			if( ClassUtils.IsDesignTime(page) )
				return false;
			Object insertState = page.Session[fullPageName + DataMember + DBWebConst.sInsertingRow];
			if( insertState == null )
				return false;
			return Convert.ToInt32(insertState) == Convert.ToInt32(InsertState.InsertStart);
		}

		public bool IsInsertingRow(Object ATableOrView)
		{
			string DataMember;
			if( ATableOrView is DataView )
				DataMember = (ATableOrView as DataView).Table.TableName;
			else
				DataMember = (ATableOrView as DataTable).TableName;
			return IsInsertingRow(DataMember);
		}

      public Page GetPage()
      {
         return page;
      }

	  public string GetFullPageName()
	  {
		 return fullPageName;
	  }

	  public bool CheckPage(Page p)
      {
      	return page == p;
      }

      public ArrayList Errors
      {
      	get
         {
         	return FErrors;
         }
      }
      public ArrayList Warnings
      {
      	get
         {
				return FWarnings;
			}
		}

	  #region finding dirty records: insertions/deletions


      protected int ChangedRowCount( string DataMember, int iToRow )
      {
		   return GetInsertCount(DataMember, iToRow) - GetDeleteCount(DataMember, iToRow);
	   }

	  // any time we check for RowCount, we need to adjust count by
	  // the # of deletions, since the table will continue holding deleted
	  // rows.
      public int GetInsertCount(string DataMember, int iToRow)
      {
         return 0;
      }

      public bool GetPageFieldsWritten()
      {
      	bool bWritten = false;
         bWritten = FHiddenRowsSet;
         FHiddenRowsSet = true;
         return bWritten;
      }

		public NameValueCollection PostCollectionValues
		{
			get
			{
				return postCollectionValues;
			}
		}

		public bool GetPostCollectionValuesSet()
		{
			bool value = FPostCollectionValuesSet;
         FPostCollectionValuesSet = true;
         return value;
      }

	  protected int AddDeletedToRowCount( string DataMember, int iToRow )
	  {
		 int iStart = 0;
		 int iTotal = iToRow;
		 int iCount = GetRowCount(DataMember);
		 for( int i = 0; i < iCount; i++ )
		 {
			if( !IsRowDeleted(DataMember, i) )
				iStart++;
			else
			   iTotal++;
			if( iStart > iToRow )
				break;
		 }
		 return iTotal;
	  }
		// if iRow == -1, get count of all deleted rows
		// if iRow == valid row, only get count of deleted
		//     rows prior to iRow
		public int GetDeleteCount( string DataMember, int iToRow )
		{
			return dataSourceAccess.GetDeleteCountFromSession(page, DataMember, iToRow);
		}
	  #endregion finding dirty records: insertions/deletions

		#region row state access functions

		// TODO: use RowID when available from Eco.
		protected ArrayList GetRows(ElementHandle handle, int iRow)
		{
			PropertyDescriptorCollection pdc = dataSourceAccess.GetPropertyDescriptors(handle);
			ArrayList row = new ArrayList();
			Type DataType;
			for( int i = 0; i < pdc.Count; i++ )
			{
				if( pdc[i].PropertyType != Type.GetType(TypeLiterals.SystemByteArray) &&
					 pdc[i].PropertyType != Type.GetType(TypeLiterals.SystemCharArray) )
				row.Add(dataSourceAccess.GetColumnValue(page, handle, pdc[i].Name, iRow, out DataType));
			}
			return row;
		}

		protected void SetCurrentObject(ElementHandle handle, string DataMember)
		{
			int iRow = getCurrentRow(DataMember);
			Object o = null;
			if( iRow >= 0 && iRow < GetRowCount(DataMember) )
				o = GetRows(handle, iRow);
			page.Session[DataMember + "_CurrentObj"] = o;
		}
		public object GetCurrentObject(string DataMember)
		{
			if( ClassUtils.IsDesignTime(page) )
				return null;
			return page.Session[DataMember + "_CurrentObj"];
		}

      public int [] CurrentRow
      {
      	get
         {
         	if( FCurrentRow == null )
            	SetupCurrentRow();
			   return FCurrentRow;
            }
      }

      public int [] RowCount
      {
      	get
         {
         	if( FRowCount == null )
            	SetupCurrentRow();
            return FRowCount;
         }
      }

      public int [] GetDeleteRows(string DataMember)
      {
         return null;
      }

	  public bool IsRowDeleted(string DataMember, int iRow)
	  {
      return false;
	  }

	  public bool IsRowInserted(string DataMember, int iRow)
	  {
         return false;
	  }

	  protected void AddDeletedRow(string DataMember, int value)
	  {
     }

      protected void AddInsertedRow(string DataMember, int value)
      {
      }

      // last row here means the row that was current prior to
      // scrolling, and does NOT mean the last row of
      // the table.  The last row of the table is RowCount
      protected int [] LastRow
      {
      	get
         {
         	if( FLastRow == null )
            	SetupCurrentRow();
            return FLastRow;
         }
		}

		private void GetDeletedAndInsertedRowsForTable(string DataMember)
		{
			if( ClassUtils.IsDesignTime(page ) )
				return;
			for( int i = 0; i < page.Session.Count; i++ )
			{
				string sKey = page.Session.Keys[i];
				if( (sKey.StartsWith( DBWebConst.sDbxDelta ) && sKey.IndexOf( DBWebConst.sDbxDelete ) > 0) ||
						(sKey.StartsWith( DBWebConst.sDbxDelta ) && sKey.IndexOf( DBWebConst.sDbxInsert ) > 0 ) )
				{
					string dataMember;
					int iRow;
					int iCol;
					string oldValue;
					ClassUtils.GetRowColFromKey(sKey, fullPageName, out dataMember, out iRow, out iCol, out oldValue);
					if( DataMember == dataMember )
					{
						if( sKey.IndexOf( DBWebConst.sDbxDelete ) > 0 )
							AddDeletedRow(DataMember, iRow);
						else
							AddInsertedRow(DataMember, iRow);
					}
				}
			}
		}

		protected int GetValueFromSession(string DataMember, string key)
		{
			Object o = page.Session[DataMember + key];
			if( o == null )
				return -1;
			return Convert.ToInt32(o);
		}

		protected void SetupCurrentRow()
		{
			SetupCurrentRow(EcoHandles);
		}

		public void SetupCurrentRow(EcoHandleCollection ecoHandles)
		{
			FCurrentRow = new int[ecoHandles.Count];
			FRowCount = new int[ecoHandles.Count];
			FLastRow = new int[ecoHandles.Count];
			for( int i = 0; i < FCurrentRow.Length; i++ )
			{
				String DataMember = ecoHandles.GetName(ecoHandles[i]);
				dataSourceAccess.IsDetailObject(ecoHandles[i], true);
				if( ClassUtils.IsDesignTime(page) )
				{
					FRowCount[i] = dataSourceAccess.GetPhysicalRowCount(page, ecoHandles[i]);
					FCurrentRow[i] = -1;
				}
				else
				{
					FRowCount[i] = GetValueFromSession(DataMember, DBWebConst.sRowCount );
					if( FRowCount[i] < 0 )
					{
						FRowCount[i] = dataSourceAccess.GetPhysicalRowCount(page, ecoHandles[i]);
					}
					FCurrentRow[i] = GetValueFromSession(DataMember, DBWebConst.sCurrentRowIndex );
				}
				if( FRowCount[i] >= 0 && FCurrentRow[i] < 0 )
					FCurrentRow[i] = 0;
				FLastRow[i] = -1;
			}
		}

		protected EcoHandleCollection EcoHandles
		{
      	get
         {
            return dataSource.EcoHandles;
         }
      }

		public int GetRowCount(string DataMember)
      {
         int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
         if( index >= 0 )
            	return RowCount[index];
        return -1;
      }

      public void SetRowCount(string DataMember, int value)
      {
         int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
         if( index >= 0 )
         {
            RowCount[index] = value;
            if( !ClassUtils.IsDesignTime(page) )
               page.Session[DataMember + DBWebConst.sRowCount] = value;
         }
      }

    	public int GetParentRowForChild(string DataMember)
      {
         return getCurrentRow(DataMember);
      }

    	public int getCurrentRow(string DataMember)
      {
         int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
         if( index >= 0 )
            return CurrentRow[index];
      	return -1;
      }

      // last row here means the row that was current prior to
      // current scrolling, and does NOT mean the last row of
      // the table.  The last row of the table is RowCount!
    	public int getLastRow(string DataMember)
      {
         int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
         if( index >= 0 )
            return FLastRow[index];
      	return -1;
      }

		public void setCurrentRow(string DataMember, int value)
		{
			int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
			if( index >= 0 )
			{
				CurrentRow[index] = value;
				if( !ClassUtils.IsDesignTime(page) )
					page.Session[DataMember + DBWebConst.sCurrentRowIndex] = value;
         }
      }

	  public void setLastRow(string DataMember, int value)
      {
         int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
         if( index >= 0 )
            LastRow[index] = value;
      }

      public void incCurrentRow(string DataMember)
      {
         int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
         if( index >= 0 )
         {
            CurrentRow[index]++;
         }
      }

      public void decCurrentRow(string DataMember)
      {
         int index = dataSourceAccess.IndexOfEcoDataMember(page, DataMember);
         if( index >= 0 )
         {
            CurrentRow[index]--;
         }
      }
	  #endregion row state access functions

	  #region child row management

	  protected int CalcRowCount( string DataMember )
	  {
		 Object handle = dataSourceAccess.GetTableOrView(page, DataMember, true, false, false);
		 return -1;
	  }

	  #endregion child row management

	  #region application statemanagement

	  // iRow is the new row, but if its past eof, before bof, or
	  // 					on a deleted row, we need to adjust it.
	  // iDirection will be +1 or -1, depending if you want to go forward or backward
	  // 				in the table
		public void ResetCurrentRow(int iRow, string DataMember, int iDirection)
		{
			int iRowCount = GetRowCount(DataMember);
			if( iRow >= iRowCount && iRowCount > -1)
				iRow = 0;
			else if( iRow < 0 )
				iRow = iRowCount -1;
			bool bThroughTable = false;
			while(iRow >= 0 && IsRowDeleted(DataMember, iRow) )
			{
				iRow += iDirection;
				if( (iRow >= iRowCount) || (iRow < 0) )
				{
					if( bThroughTable )
						iRow = -1;  // there is no current row: set to -1 and exit loop
					else
					{
						if( iRow < 0 )
							iRow = iRowCount -1;
						else
							iRow = 0;
						bThroughTable = true;
					}
				}
			}
			setCurrentRow(DataMember, iRow);
		}

		protected ArrayList RegularizeParentRows(string DataMember)
		{ // ensure that all Deleted and Inserted Rows have same Key value
			// for same parent row.
			ArrayList parentRows = new ArrayList();
			int index = dataSource.IndexOfEcoDataMember(page, DataMember);
			for( int i = 0; i < CurrentRow.Length; i++ )
			{
				if( i == index )
					parentRows.Add(0);
				else
					parentRows.Add(CurrentRow[i]);
			}
			return parentRows;
		}

	  private DataRow RowFromObject(object tableOrView, int iRow)
		{
			if( tableOrView is DataTable )
			{
			if( iRow < (tableOrView as DataTable).Rows.Count )
					return (tableOrView as DataTable).Rows[iRow];
			}
			else if( tableOrView is DataView )
				if( iRow < (tableOrView as DataView).Count )
            	return (tableOrView as DataView)[iRow].Row;
         return null;
      }

		protected DataColumn ColumnFromColumnName(object table, int iColumn)
      {
         if( table is DataTable )
         	return (table as DataTable).Columns[iColumn];
         else if (table is DataView)
         	return (table as DataView).Table.Columns[iColumn];
         return null;
      }

		protected void SaveCurrentRows(ArrayList currentRows)
		{
			string DataMember;
			for( int i = 0; i < EcoHandles.Count; i++ )
			{
				DataMember = Convert.ToString(EcoHandles[i]);
				currentRows.Add(getCurrentRow(DataMember));
				setCurrentRow(DataMember, getLastRow(DataMember));
			}
		}

		protected void RestoreCurrentRows(ArrayList currentRows)
		{
			string DataMember;
			for( int i = 0; i < EcoHandles.Count; i++ )
			{
				DataMember = Convert.ToString(EcoHandles[i]);
				setCurrentRow(DataMember, Convert.ToInt32(currentRows[i]));
//				SetDatasetUpdated(DataMember, false);
			}
		}

      protected DataTable TableFromObject(object o)
      {
         if( o is DataView )
            return (o as DataView).Table;
         return o as DataTable;
	  }

	  // first update the Session manager for Insert or Delete
	  // 		button hit.
		// then call ForceUpdate to update the Session manager
	  // 		for changes made in row values.
		public void UpdateApplicationState(ElementHandle handle, string DataMember, int ParentRow)
		{
			// if a detail object, set CurrencyManager to old Parent Row
			int CurrentRow = dataSourceAccess.CheckParentRow(this, handle, DataMember, ParentRow);
			try
			{
				ForceUpdate(handle, DataMember);
			}
			finally
			{
				// ... and reset if changed
				if( CurrentRow >= 0 )
					dataSourceAccess.CheckParentRow(this, handle, DataMember, CurrentRow);
			}
		}

	  public bool HasDelta()
	  {
		for( int i = 0; i < EcoHandles.Count; i++ )
			if( HasDelta( EcoHandles[i].ToString() ) )
				return true;
		return false;
	  }

	  public bool HasDelta(string DataMember)
	  {
      	  if( !ClassUtils.IsDesignTime(page) )
             return iDataSource.HasDelta(page, DataMember);
		  return false;
	  }
	  #endregion application state management


     #region handling client requests

      protected bool SameType(Type t, string DataMember)
      {
         // TODO: for testing, needs to be refined.
         return t.ToString().StartsWith(DataMember);
      }
      protected void InsertObject(string DataMember)
      {
         ElementHandle handle = EcoHandle(DataMember);
         if( handle != null )
         {
            Type t = null;
            int dotPos = DataMember.IndexOf(".");
            if( dotPos > 0 )
               DataMember = DataMember.Substring(0, dotPos);
            EcoSpace es = dataSourceAccess.GetEcoSpace(page);
            if( t != null )
				{
					Object o = Activator.CreateInstance(handle.GetType());
				}
			}
		}


		// returns true if row position has changed
		protected bool HandleClientAction(ClientAction clientAction, int ARowCount,
							ElementHandle handle, string DataMember, int ParentRow, int RowToSet)
		{
			int currentRow = FCurrentRowHolder;
			int Direction = 1;
			bool FRowChanged = false;
			bool bUndo = false;
			switch(clientAction)
			{
				case ClientAction.ecaPrevious:
					if( FCurrentRowHolder > 0 )
					{
						page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sPrevText;
						FCurrentRowHolder -= 1;
						Direction = -1;
						FRowChanged = true;
					}
					break;
				case ClientAction.ecaNext:
					if( FCurrentRowHolder +1 < GetRowCount(DataMember) )
					{
						page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sNextText;
						FCurrentRowHolder += 1;
						FRowChanged = true;
					}
					break;
				case ClientAction.ecaFirst:
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sFirstText;
					FCurrentRowHolder = 0;
					FRowChanged = true;
					break;
				case ClientAction.ecaLast:
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sLastText;
					Direction = -1;
					FCurrentRowHolder = ARowCount -1;
					FRowChanged = true;
					break;
				case ClientAction.ecaUndo:
					dataSourceAccess.UndoLatestChange(page, handle);
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sUndoText;
					bUndo = true;
					break;
				case ClientAction.ecaUndoAll:
					dataSourceAccess.UndoAllChanges(page, handle);
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sUndoAllText;
					bUndo = true;
               break;
				case ClientAction.ecaInsert:
					UpdateApplicationState( handle, DataMember, ParentRow );
					dataSource.InsertRow(page, DataMember);
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sInsertText;
					FCurrentRowHolder = GetRowCount(DataMember);
					SetRowCount(DataMember, FCurrentRowHolder + 1);
					FRowChanged = false;
					page.Session[fullPageName + DataMember + DBWebConst.sInsertingRow] = InsertState.InsertStart;
					break;
            case ClientAction.ecaDelete:
            case ClientAction.ecaDeleteRow:
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sDeleteText;
					if( clientAction == ClientAction.ecaDeleteRow)
						FRowChanged = true;
					// clicked on Delete Linked Column, need to move to that row.
					if( clientAction == ClientAction.ecaDeleteRow )
						FCurrentRowHolder = AddDeletedToRowCount( DataMember, RowToSet );
					// else, if clientAction is delete current row, use current row
					FCurrentRowHolder = getCurrentRow(DataMember);
					dataSource.DeleteRow(page, DataMember, FCurrentRowHolder);
					break;
            case ClientAction.ecaSetRow:
					FRowChanged = true;
               FCurrentRowHolder = AddDeletedToRowCount( DataMember, RowToSet );
					break;
			}
			if( FRowChanged || clientAction == ClientAction.ecaNone)
				UpdateApplicationState( handle, DataMember, ParentRow );
			// only 1 navigator control can change rows at a time.  So if parent
			// table has already set new row, it will reset child row to 0.
			// When this happens, the child row must not be set to the current row
			// value retrieved from page's hidden SRowIndex value for that table.
         if( FErrors.Count > 0 )	// don't move on to next record if error occurred during update
            ResetCurrentRow(currentRow, DataMember, Direction);
         else
				ResetCurrentRow(FCurrentRowHolder, DataMember, Direction);
			if( bUndo )  // might alter CurrentRow position
			{
				// TODO: Echo Undo stuff
			}
			if( clientAction != ClientAction.ecaDelete && clientAction != ClientAction.ecaInsert &&
				clientAction != ClientAction.ecaUndo)
			{
				// if Detail table has deleted rows, this can leave the Current
				// Row value at a state greater than the RowCount
				SetRowCount(DataMember, GetRowCount(DataMember) );
			}
			return FRowChanged;
		}

      private ClientAction GetClientAction(NameValueCollection postCollection, string DataMember, ref int RowToSet, ref bool bNewRow)
      {
			int FRowCountHolder = Convert.ToInt32(page.Session[DataMember + DBWebConst.sRowCount]);
         ClientAction clientAction = ClientAction.ecaNone;
			if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sNextText) )
				clientAction = ClientAction.ecaNext;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sPrevText) )
				clientAction = ClientAction.ecaPrevious;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sFirstText) )
				clientAction = ClientAction.ecaFirst;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sLastText) )
				clientAction = ClientAction.ecaLast;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sApplyText) )
				clientAction = ClientAction.ecaApply;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sRefreshText) )
				clientAction = ClientAction.ecaRefresh;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sDeleteText) )
			{  // if the # of undeleted rows is 0, return
				if( FRowCountHolder - GetDeleteCount(DataMember, -1) == 0 )
					clientAction = ClientAction.ecaCancel;
				clientAction = ClientAction.ecaDelete;
			}
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sInsertText) )
			{
				if( dataSource.DataSource is DataView )
				{
					if( !ClassUtils.IsEmpty((dataSource.DataSource as DataView).Sort ))
                  clientAction = ClientAction.ecaCancel;
				}
				clientAction = ClientAction.ecaInsert;
				bNewRow = true;
			}
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sUndoText) )
				clientAction = ClientAction.ecaUndo;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sUndoAllText) )
				clientAction = ClientAction.ecaUndoAll;
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sSetRow ) )
			{
				RowToSet = Convert.ToInt32(postCollection[DataMember + DBWebConst.Splitter + DBWebConst.sSetRow]);
				clientAction = ClientAction.ecaSetRow;
			}
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sDeleteRow ) )
			{
				if( FRowCountHolder - GetDeleteCount(DataMember, -1) == 0 )
               clientAction = ClientAction.ecaCancel;
				clientAction = ClientAction.ecaDeleteRow;
				RowToSet = Convert.ToInt32(postCollection[DataMember + DBWebConst.Splitter + DBWebConst.sDeleteRow]);
			}
			else if( ClassUtils.PostCollectionHasValue(postCollection, DataMember, DBWebConst.sCancelChange ) )
            clientAction = ClientAction.ecaCancel;
         return clientAction;
      }

      private void SetTablesUpdated(string DataMember, bool value)
      {
//         SetDatasetUpdated(DataMember, false);
      }

		public void SetChangedValues(NameValueCollection postCollection)
		{
			dataSourceAccess.SetEcoSpaceActive(page, true);
			for( int i = 0; i < EcoHandles.Count; i++ )
			{
				SetChangedValues(postCollection, EcoHandles[i], EcoHandles.GetName(i));
			}
		}

		protected void UpdateCursorHandles(ElementHandle handle, int currentRow)
		{
			for( int i = 0; i < EcoHandles.Count; i++ )
			{
				if( EcoHandles[i] != handle )
				{
					CursorHandle cursorHandle = EcoWebUtils.GetRootHandle(EcoHandles[i]) as CursorHandle;
					if( cursorHandle != null )
					{
						ElementHandle nextHandle = EcoWebUtils.GetRootHandle(cursorHandle);
						if( nextHandle == handle )
						{
							cursorHandle.Position = currentRow;
							FRowCount[i] = dataSourceAccess.GetPhysicalRowCount(page, handle);
							if( FRowCount[i] >= 0 )
								FCurrentRow[i] = 0;
							else
								FCurrentRow[i] = -1;
						}
					}
				}
			}
		}

		protected void SetChangedValues(NameValueCollection postCollection, ElementHandle handle, string DataMember)
		{
			int SaveRow;
			bool bRowChanged = false;
			bool bNewRow = false;
			int RowToSet = -1;
			int ParentRow = -1;
			int LastRow = -1;
			int FRowCountHolder = Convert.ToInt32(page.Session[DataMember + DBWebConst.sRowCount]);
			FCurrentRowHolder = Convert.ToInt32(page.Session[DataMember + DBWebConst.sCurrentRowIndex]);
			SaveRow = FCurrentRowHolder;
			ParentRow = Convert.ToInt32(page.Session[DataMember + DBWebConst.sFirstParentRow]);
			try
			{
				LastRow = Convert.ToInt32(page.Session[DataMember + DBWebConst.sLastRow]);
				page.Session.Remove(DataMember + DBWebConst.sLastButtonSelected);
				if( GetInsertState(DataMember) == InsertState.InsertStart )
					SetInsertState(DataMember, InsertState.InsertEnd);
				if( LastRow == -1 )
					setLastRow(DataMember, FCurrentRowHolder);
				else
					setLastRow(DataMember, LastRow);
				postCollectionValues.Clear();
				for(int i = 0; i < postCollection.Count; i++ )
					postCollectionValues.Add(postCollection.GetKey(i), postCollection.Get(i));
				clientAction = GetClientAction(postCollection, DataMember, ref RowToSet, ref bNewRow);
				if( clientAction == ClientAction.ecaCancel )
					return;
/*				else if( clientAction == ClientAction.ecaPrevious ||
					clientAction == ClientAction.ecaLast ) */
				else if( clientAction == ClientAction.ecaNone ) // got here without hitting any known navigator button or grid button
					UpdateApplicationState( handle, DataMember, ParentRow );
				if( clientAction != ClientAction.ecaApply && clientAction != ClientAction.ecaNone)
					bRowChanged = HandleClientAction(clientAction, FRowCountHolder, handle, DataMember, ParentRow, RowToSet );
				if( clientAction == ClientAction.ecaApply )
				{
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sApplyText;
					if(clientAction == ClientAction.ecaApply)
						dataSourceAccess.DoOnApplyChanges(page);
				}
				else if( clientAction == ClientAction.ecaRefresh )
				{
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sRefreshText;
					dataSourceAccess.DoOnRefresh(page);
				}
				if( bRowChanged || clientAction == ClientAction.ecaInsert )
				{
					SetTablesUpdated(DataMember, false);
					page.Session[DataMember + DBWebConst.sLastButtonSelected] = DBWebConst.sInsertText;
					dataSourceAccess.DoOnScroll(DataMember, getCurrentRow(DataMember), getLastRow(DataMember) );
					for( int i = 0; i < dataSource.EcoHandles.Count; i++ )
					{
						if( dataSource.EcoHandles[i].ToString() == DataMember )
							FRowChangeController = i;
					}
				}
				if( clientAction != ClientAction.ecaInsert )
				{
					page.Session.Remove(fullPageName + DataMember + DBWebConst.sInsertingRow);
				}
				UpdateCursorHandles(handle, FCurrentRowHolder);
				clientAction = ClientAction.ecaNone;
				SetCurrentObject(handle, DataMember);
			}
			finally
			{
			}
		}

	  #endregion handling client requests

  	  #region DataSet updates

/*      protected int[] GetCurrentRows(string DataMember)
	  {
		 int index = dataSource.IndexOfTable(DataMember);
		 int [] cr = new int[FCurrentRow.Length];
		 for( int i = 0; i < cr.Length; i++ )
		 {
			if(i == index)
				cr[i] = FCurrentRowHolder;
			else
				cr[i] = FCurrentRow[i];
		 }
		 return cr;
	  } */

      protected bool UnwritableColumn(string dataType)
		{	// { do not localize and consts here }
			if( dataType.IndexOf("System.Byte[]") >= 0  ||
      			(dataType.IndexOf("System.TimeSpan") >= 0)  ||
               (dataType.IndexOf("System.Object") >= 0) )
         	return true;
		 return false;
	  }

	  protected PropertyDescriptor GetPropertyDescriptorByName(PropertyDescriptorCollection pdc, string sColumn, out int MemberIndex)
	  {
			MemberIndex = -1;
			for( int i = 0; i < pdc.Count; i++ )
				if( pdc[i].Name == sColumn )
            {
               MemberIndex = i;
               return pdc[i];
            }
        return null;
	 }

	  public bool UpdateChanges(NameValueCollection changedValues, ElementHandle handle,
								PropertyDescriptorCollection pdc, string DataMember, int iRow)
	  {
		string sColumn;
		string sCurrent = null;
		string sNew;
		bool bDataSetChanged = false;
		Object thisObject = dataSourceAccess.GetEcoObject(handle, iRow);
		for( int i = 0; i < changedValues.Count; i++ )
		{
			try
			{
				sColumn = changedValues.GetKey(i);
				if( FDuplicateColumns.IndexOf(sColumn) >= 0 )
				{
				  string sDuplicateColumn = BdwResources.GetString("DuplicateColumn");
				  LogWarning(sColumn + ": " + sDuplicateColumn);
				}
				int MemberIndex;
				PropertyDescriptor pd = GetPropertyDescriptorByName(pdc, sColumn, out MemberIndex);
				if( pd == null )
					continue;
				string dataType = pd.PropertyType.ToString();
				if( UnwritableColumn(dataType) )
					continue;
				else
				{
					Type DataType;
					sCurrent = Convert.ToString(dataSourceAccess.GetColumnValue(page, handle, sColumn, iRow, out DataType));
					sNew = changedValues[sColumn];
					if( !ClassUtils.CompareObjects(sCurrent, sNew, dataType) )
					{
						bDataSetChanged = true;
						string sKey = ClassUtils.GenKeyName(fullPageName, DBWebConst.sDbxDelta, DataMember, iRow, MemberIndex, sCurrent, FCurrentRow);
						try
						{
							dataSourceAccess.SetColumnValue(page, handle, iRow, pd, sNew);
							RemoveAggKeyForColumn(DataMember, sColumn);
						}
						catch( Exception ex )
						{
							HandleException(ex, sKey, false);
						}
					}
				}
			}
			catch( Exception ex1 )
			{
				HandleException(ex1, "", false);
			}
		 }
		 return bDataSetChanged;
	  }

	  protected string FindColumnNameForColumnControl(PropertyDescriptorCollection pdc,
                      string postKey, NameValueCollection postCollection, string DataMember)
	  {
		 if( postKey == (DataMember + DBWebConst.sCurrentRowIndex) ||
         		postKey == (DataMember + DBWebConst.sRowCount) ||
               postKey.StartsWith(DBWebDataSource.IdentPrefix) )
         	return null;
         string ColumnName = null;
      	for( int i = 0; i < postCollection.Count; i++)
         {
            string sKey = postCollection.GetKey(i);
         	if(sKey == DBWebDataSource.IdentPrefix + postKey)
            {
            	ColumnName = postCollection.Get(i).ToString();
               if( ColumnName.StartsWith(DataMember + DBWebConst.Splitter) )
               	return ColumnName.Substring(ColumnName.IndexOf(DBWebConst.Splitter) + 1);
            }
         }
         return null;
     }

      // ReadOnly fields and blob fields are ignored
     protected bool GridColumnNotUsed(PropertyDescriptor pd)
     {
      	string sType = pd.GetType().ToString();
         return ( UnwritableColumn(sType) ||
             sType.IndexOf("System.Char[]") >= 0 );
     }
      // GetColumnName for persistent Grid Columns.
      //
      protected string FindBoundColumnNameForGrid(string GridId, ref int iGridColumns)
      {	// since each grid is associated with a single table, DataTable and DataMember are not needed here
      	object o = page.Session[GridId + Convert.ToString(iGridColumns)];
         if( o != null )
         {
            iGridColumns++;
            return o.ToString();
         }
         return null;
      }

//    assuming that the "_ctl#" portion of the postCollection is the last part of the
//        key value, and that it is sufficient to tell the column #.
//        the GridColumnNotUsed() call checks for Blobs and readonly columns;
//        adjust this for blobs, and possibly for user added columns as well.
      protected string FindColumnNameForGrid(PropertyDescriptorCollection pdc, string sKey, ref int iGridColumns)
      {
         const int MaxColumns = 2000;

         //  Code assumes
         //  1.  GridColumns (ButtonColumn, EditCommandColumn, etc.)
         //  don't show up as submits to postCollection;
         //  2.  _ctrl0 precedes _ctrl1, etc.  However, there is no guarantee
         //  it will start with _ctrl0.  If there are three GridColumns, then
         //  it will start with _ctrl4.  If persistent columns are used,
         //  then FindBoundColumnNameForGrid is called instead.
         // ------------------------------------------------------------------
         //  First, make sure sKey contains grid column
         if( sKey.IndexOf(FAspGridId) > 0 )
         {
         	for( int i = 0; i < MaxColumns; i++ )
            {
               if( sKey.EndsWith(FAspGridId + Convert.ToString(i) ) )
               {
                  // make sure Column is not blob (not in grid) or read-only field
               		while( iGridColumns < pdc.Count &&
                                 GridColumnNotUsed(pdc[iGridColumns]))
									iGridColumns++;
							if( iGridColumns <= pdc.Count )
							{
								iGridColumns++;
								return pdc[iGridColumns-1].Name;
                     }
               }
            }
         }
         return null;
      }

      private ArrayList GetGridControls(NameValueCollection postCollection, string DataMember)
      {
         ArrayList AList = new ArrayList();
      	for( int i = 0; i < postCollection.Count; i++ )
         {
            string sKey = postCollection.GetKey(i);
            string sValue = postCollection.Get(i).ToString();
            // registered in DBWebGrid.PreRender()
				if( sKey.StartsWith(DBWebConst.sDBWebDataGrid + DBWebConst.Splitter + DataMember) )
            	AList.Add(sValue + FAspGridId);
         }
         return AList;
      }

      private bool IsGridColumn(string sKey, ArrayList AList, out string GridID)
      {
         string sCheck;
         GridID = null;
      	for( int i = 0; i < AList.Count; i++ )
         {
            sCheck = AList[i].ToString();
         	if( sKey.StartsWith( sCheck ) )
            {
               GridID = sCheck.Substring(0, sCheck.IndexOf(FAspGridId));
            	return true;
            }
         }
         return false;
      }

      protected int GridColumnCount(string sKey)
      {
         if( ClassUtils.IsDesignTime(page) )
         	return 0;
      	 int EndName = sKey.IndexOf(FAspGridId);
         if( EndName > 0 )
         {
         	string controlName = sKey.Substring(0, EndName);
            object o = page.Session[controlName + FAspGridId];
            if( o != null )
            	return Convert.ToInt32(o) + 1;
         }
         return 0;
      }

      protected int GetPushButtonCount(string sKey, out int iCurrentIndex)
      {
         iCurrentIndex = 0;
         if( ClassUtils.IsDesignTime(page) )
         	return 0;
      	 int EndName = sKey.IndexOf(FAspGridId);
         if( EndName > 0 )
         {
         	string controlName = sKey.Substring(0, EndName);
            object o = page.Session[controlName + DBWebConst.sGridPushButtonCount];
            if( o != null )
            {
                string sIndex = sKey.Substring(sKey.LastIndexOf(DBWebConst.sGridColumnID) +
                                DBWebConst.sGridColumnID.Length);
            	iCurrentIndex = Convert.ToInt32(sIndex);
            	return Convert.ToInt32(o);
            }
         }
         return 0;
      }

      protected bool IsPushButton(string sKey)
      {
        int iIndex;
      	int iPushButtonCount = GetPushButtonCount(sKey, out iIndex);
        if( iIndex < iPushButtonCount )
           return true;
        return false;
      }

//    Web Column controls call register hidden fields to identify the column
// 			associated with the control
//    Grid controls register their ID's so the Grid Column can be identified.
      protected string FindColumnName(PropertyDescriptorCollection pdc, string postKey,
                        ArrayList GridList, NameValueCollection postCollection,
                        ref int iColumns, string DataMember)
      {
         string sGridId;
         if( IsGridColumn( postKey, GridList, out sGridId) )
         {
            if( postCollection[DBWebConst.sDBWebDataGrid + DBWebConst.Splitter + DataMember] != sGridId )
                return null;
            if( iColumns == 0 )
            {
            	object error = page.Session[sGridId + DBWebConst.sInvalidBoundColumns];
               if( error != null && Convert.ToBoolean(error) )
               		throw new Exception(BdwResources.GetString("InvalidGridColumns") + ":" + sGridId);
            }
            if( IsPushButton( postKey ) )
            	return null;
            object o = page.Session[sGridId + DBWebConst.sAutoGenerateColumns];
            if( o == null || Convert.ToBoolean(o) )
         		return FindColumnNameForGrid(pdc, postKey, ref iColumns);
            else
            	return FindBoundColumnNameForGrid(sGridId, ref iColumns);
         }
         else
         	return FindColumnNameForColumnControl(pdc, postKey, postCollection, DataMember);
	  }

		public void ForceUpdate(ElementHandle handle, string DataMember)
	   {
         string sKey;
			string sColumnName;
			PropertyDescriptorCollection pdc = dataSourceAccess.GetPropertyDescriptors(handle);
		   int iRowCount = dataSourceAccess.GetPhysicalRowCount(page, handle);
         if( iRowCount > 0 )
         {
            try
            {
   			   int iRow = getLastRow(DataMember);
	   		   // if the last row just been deleted don't try to check for changes
   		   	// in it.
	   		   if( iRow == -1 )
		   		   return;
   	   		FDuplicateColumns.Clear();
	   	   	NameValueCollection changes = new NameValueCollection();
		   	   int iGridColumns = 0;
   			   ArrayList GridList = GetGridControls(postCollectionValues, DataMember);
               for( int i = 0; i < postCollectionValues.Count; i++ )
					{
						sKey = postCollectionValues.GetKey(i);
						sColumnName = FindColumnName(pdc, sKey, GridList, postCollectionValues, ref iGridColumns, DataMember);
						if( sColumnName != null && sColumnName != "" )
                  {
                     if( changes[sColumnName] == null )
                        changes.Add( sColumnName, postCollectionValues.Get(i));
                     else
                     {
                        FDuplicateColumns.Add(sColumnName);
                        iGridColumns --;
                     }
                  }
               }
		         if( changes.Count > 0 && handle != null )
		         {
				      UpdateChanges(changes, handle, pdc, DataMember, iRow);
               }
            }
			   catch(Exception ex)
			   {
				   HandleException(ex, "", false);
			   }
		   }
         return;
      }

	  #endregion DataSet updates

     #region ErrorHandling
      public void HandleException(Exception exp, string UpdateKey, bool bExtended)
      {
         int MinMessageLength = 15;
         if( UpdateKey != "" )
            page.Session.Remove(UpdateKey);
         string sMsg = exp.Message;
         int iStackPos = sMsg.IndexOf(AtSysError);
         if( iStackPos > MinMessageLength )
            sMsg = sMsg.Substring(0, iStackPos -1);
         if( !bExtended && FErrors.IndexOf(sMsg) >= 0 )
            return;
         if( FErrors.IndexOf(sMsg) < 0 )
            FErrors.Add(sMsg);
      }

      public void LogWarning(string sMsg)
      {
         if( FWarnings.IndexOf(sMsg) < 0 )
            FWarnings.Add(sMsg);
      }
      
	  protected DataTable GetErrorTable(bool bWarnings)
      {
      	DataTable dt = new DataTable();
         string sError;
         if( bWarnings )
         {
	         if( FWarnings.Count > 1 )
   	        sError = BdwResources.GetString("WarningText");
      	   else
         	  sError = BdwResources.GetString("OneWarningText");
         }
         else
		 {
			 if( FErrors.Count > 1 )
   	        sError = BdwResources.GetString("ErrorsText");
      	   else
         	  sError = BdwResources.GetString("OneErrorText");
         }
         dt.Columns.Add(sError, Type.GetType("System.String"));

         int iCount;
		   if( bWarnings )
			iCount = FWarnings.Count;
         else
          	iCount = FErrors.Count;
		 for( int i = 0; i < iCount; i++ )
         {
         	DataRow dr = dt.NewRow();
            if( bWarnings )
         		dr[0] = FWarnings[i].ToString();
            else
         		dr[0] = FErrors[i].ToString();
         	dt.Rows.Add(dr);
         }
         return dt;
		}

		public bool ClearLastError(string DataMember, bool bVerifyInErrorState)
		{
			if( bVerifyInErrorState )
			{
				Object o = page.Session[DataMember + DBWebConst.sErrorState];
				if( o == null )
					return false;
			}
			for( int i = page.Session.Count - 1; i >= 0; i-- )
			{
				string sKey = page.Session.Keys[i];
				if( sKey.StartsWith(DBWebConst.sDbxDelta) )
				{
					page.Session.Remove(sKey);
					break;
				}
			}
			ResetCurrentRow(0, DataMember, 1);
			page.Session.Remove(DataMember + DBWebConst.sErrorState);
			return true;
		}

		public string ErrorHtml(string DataMember)
		{
			if( FErrors.Count == 0 )
				return "";
			StringWriter sw = new StringWriter();
			HtmlTextWriter tw = new HtmlTextWriter(sw);
			DataGrid errorGrid = new DataGrid();
			errorGrid.ID = "errorGrid";
			errorGrid.DataSource = GetErrorTable(false);
			errorGrid.BorderWidth = dataSource.ErrorDlgBorderWidth;
			errorGrid.BackColor = dataSource.ErrorDlgBackColor;
			errorGrid.ForeColor = dataSource.ErrorDlgForeColor;
			errorGrid.BorderColor = dataSource.ErrorDlgBorderColor;
			errorGrid.DataBind();
			errorGrid.RenderControl(tw);
         Errors.Clear();
			if( !ClearLastError(DataMember, true) )
				page.Session[DataMember + DBWebConst.sErrorState] = true;
			return sw.ToString() + "<br>";
		}

	  public string WarningsHtml(string DataMember)
	  {
			if( FWarnings.Count == 0 )
				return "";
		   StringWriter sw = new StringWriter();
			HtmlTextWriter tw = new HtmlTextWriter(sw);
			DataGrid errorGrid = new DataGrid();
			errorGrid.ID = "errorGrid";
         errorGrid.DataSource = GetErrorTable(true);
         errorGrid.BorderWidth = dataSource.ErrorDlgBorderWidth;
         errorGrid.BackColor = dataSource.ErrorDlgBackColor;
         errorGrid.ForeColor = dataSource.ErrorDlgForeColor;
         errorGrid.BorderColor = dataSource.ErrorDlgBorderColor;
         errorGrid.DataBind();
         errorGrid.RenderControl(tw);
         FWarnings.Clear();
         return sw.ToString() + "<br>";
      }

      #endregion ErrorHandling

      #region Aggregates
      protected void RegisterAggKey(string AggKey)
      {
			int iAggKeyCount = 0;
			string Key;
			for( int i = 0; i < page.Session.Count; i++ )
			{
				Key = page.Session.Keys[i];;
				if( Key.StartsWith(DBWebConst.sAggKey ) )
					iAggKeyCount++;
			}
			Key = DBWebConst.sAggKey + Convert.ToString(iAggKeyCount);
			// If a key has been removed and a new one added, then
			// gaps will occur.  Adjust for this here.
			while( page.Session[Key] != null )
			{
				iAggKeyCount++;
				Key = DBWebConst.sAggKey + Convert.ToString(iAggKeyCount);
			}
			page.Session.Add(Key, AggKey);
		}
		
      protected void RemoveAggKeyForColumn(string DataMember, string ColumnName)
      {
         string AggKey;
         string Key;
         for( int i = page.Session.Count -1; i >= 0; i--)
         {
            Key = page.Session.Keys[i];;
            if( Key.StartsWith(DBWebConst.sAggKey ) )
            {
               AggKey = Convert.ToString(page.Session[Key]);
               if( (AggKey.IndexOf(DBWebConst.sAggregates +
                    DataMember + DBWebConst.Splitter + ColumnName) >= 0) ||
                    (ClassUtils.IsEmpty(ColumnName) ) )
               {
                  page.Session.Remove(AggKey);
						page.Session.Remove(Key);
					}
				}
			}
		}

		protected double UpdateAggregateTotal(string DataMember, string ColumnName, bool getAvg, bool ignoreNullValues)
		{
			ElementHandle handle = dataSourceAccess.GetTableOrView(page, DataMember, true, false, false) as ElementHandle;
			double dSum = 0;
			Object o = null;
			int nullCount = 0;
			int iCount = dataSourceAccess.GetPhysicalRowCount(page, handle);
			Type DataType;
			for( int i = 0; i < iCount; i++ )
			{
				if( ClassUtils.IsDesignTime(page) || (!IsRowDeleted(DataMember, i)) )
				{
					o = dataSourceAccess.GetColumnValue(page, handle, ColumnName, i, out DataType);
					if( o != null && !(o is System.DBNull) )
						dSum += Convert.ToDouble(o);
					else
						nullCount++;
				}
			}
			if( getAvg )
			{
				if( ignoreNullValues )
				{
               if( (iCount - nullCount) > 0 )
                  dSum = dSum / (iCount - nullCount);
				}
				else
            {
               if( iCount > 0 )
                  dSum = dSum / iCount;
            }
			}
         return dSum;
      }

		protected int ObjectCompare(Object o1, Object o2)
		{
			int iCompare = 0;
			if( o1 == null )
			{
				if( o2 != null )
					iCompare = -1;
			}
			else if( o2 == null )
			{
				if( o1 != null )
					iCompare = 1;
			}
			else
			{
				Type type = o1.GetType();
				if( type == Type.GetType(TypeLiterals.SystemString) )
						iCompare = o1.ToString().CompareTo(o2.ToString());
				else if(type == Type.GetType(TypeLiterals.SystemDouble) )
						iCompare = Convert.ToDouble(o1).CompareTo(Convert.ToDouble(o2));
				else if(type == Type.GetType(TypeLiterals.SystemInt32))
						iCompare = Convert.ToInt32(o1).CompareTo(Convert.ToInt32(o2));
				else if(type == Type.GetType(TypeLiterals.SystemInt16))
						iCompare = Convert.ToInt16(o1).CompareTo(Convert.ToInt16(o2));
				else if(type == Type.GetType(TypeLiterals.SystemUInt32))
						iCompare = Convert.ToUInt32(o1).CompareTo(Convert.ToUInt32(o2));
				else if(type == Type.GetType(TypeLiterals.SystemUInt16))
						iCompare = Convert.ToUInt16(o1).CompareTo(Convert.ToUInt16(o2));
				else if(type == Type.GetType(TypeLiterals.SystemInt64))
						iCompare = Convert.ToInt64(o1).CompareTo(Convert.ToInt64(o2));
				else if(type == Type.GetType(TypeLiterals.SystemDateTime))
						iCompare = Convert.ToDateTime(o1).CompareTo(Convert.ToDateTime(o2));
				else if(type == Type.GetType(TypeLiterals.SystemDecimal))
						iCompare = Convert.ToDecimal(o1).CompareTo(Convert.ToDecimal(o2));
				else if(type == Type.GetType(TypeLiterals.SystemSingle))
						iCompare = Convert.ToSingle(o1).CompareTo(Convert.ToSingle(o2));
				else if(type == Type.GetType(TypeLiterals.SystemChar))
						iCompare = Convert.ToChar(o1).CompareTo(Convert.ToChar(o2));
			}
			return iCompare;
		}

		protected Object UpdateAggregateMinOrMax(string DataMember, string ColumnName, bool bMin, bool ignoreNull)
		{
			ElementHandle handle = dataSourceAccess.GetTableOrView(page, DataMember, false, false, false) as ElementHandle;
			int iCount = dataSourceAccess.GetPhysicalRowCount(page, handle);
			Object o = null;
			Object o2;
			Type DataType;
			for( int i = 0; i < iCount; i++ )
			{
				if( ClassUtils.IsDesignTime(page) || (!IsRowDeleted(DataMember, i)) )
				{
					o2 = dataSourceAccess.GetColumnValue(page, handle, ColumnName, i, out DataType);
					if( o2 == null && ignoreNull )
						continue;
					if( o == null )
					{
						if( !(o2 is System.DBNull) )
							o = o2;
					}
					else
					{
						if( o2 == null || o2 is System.DBNull )
						{
							if( bMin )
								o = null;
						}
						else
						{
							int iCompare = ObjectCompare(o, o2);
							if( bMin && iCompare > 0)
								o = o2;
							else if( !bMin && iCompare < 0 )
								o = o2;
						}
					}
				}
			}
			return o;
		}

		protected Object GetMinForField(string DataMember, string ColumnName, bool ignoreNullValues)
		{
			string sKey = DBWebConst.sAggregates + DataMember + DBWebConst.Splitter + ColumnName +
							  DBWebConst.Splitter + DBWebConst.sAggMin;
			Object o;
			if( !ClassUtils.IsDesignTime(page) )
				o = page.Session[sKey];
			else
				o = null;
			if( o == null )
			{
				o = UpdateAggregateMinOrMax(DataMember, ColumnName, true, ignoreNullValues);
				if( !ClassUtils.IsDesignTime(page) )
				{
					RegisterAggKey(sKey);
					page.Session[sKey] = o;
				}
			}
			return o;
		}

      protected Object GetMaxForField(string DataMember, string ColumnName, bool ignoreNullValues)
      {
         string sKey = DBWebConst.sAggregates + DataMember + DBWebConst.Splitter + ColumnName +
                       DBWebConst.Splitter + DBWebConst.sAggMax;
         Object o;
         if( !ClassUtils.IsDesignTime(page) )
            o = page.Session[sKey];
         else
            o = null;
         if( o == null )
         {
            o = UpdateAggregateMinOrMax(DataMember, ColumnName, false, ignoreNullValues);
            if( !ClassUtils.IsDesignTime(page) )
            {
               RegisterAggKey(sKey);
               page.Session[sKey] = o;
            }
         }
         return o;
      }

      protected Object GetTotalOrAvgForField(string DataMember, string ColumnName, bool getAvg, bool ignoreNulls)
      {
         string sKey;
         if( getAvg )
				sKey = ClassUtils.GenKeyForAggregate(fullPageName, DataMember, ColumnName,
                       ignoreNulls, DBWebConst.sAggAvg);
         else
            sKey = ClassUtils.GenKeyForAggregate(fullPageName, DataMember, ColumnName,
							  ignoreNulls, DBWebConst.sAggTotal);
			Object o;
         if( !ClassUtils.IsDesignTime(page) )
            o = page.Session[sKey];
         else
            o = null;
         if( o == null )
         {
            o = UpdateAggregateTotal(DataMember, ColumnName, getAvg, ignoreNulls);
            if( !ClassUtils.IsDesignTime(page) )
            {
               RegisterAggKey(sKey);
               page.Session[sKey] = o;
            }
			}
			return o;
		}

		protected Object AggCount(string DataMember, string ColumnName, bool ignoreNullValues)
		{
			int iCount = GetRowCount(DataMember);
			Type DataType;
			if( ignoreNullValues )
			{
				ElementHandle handle = dataSourceAccess.GetTableOrView(page, DataMember, true, false, false) as ElementHandle;
				for( int i = 0; i < iCount; i++ )
				{
					if( ClassUtils.IsDesignTime(page) || (!IsRowDeleted(DataMember, i)) )
					{
						Object o = dataSourceAccess.GetColumnValue(page, handle, ColumnName, i, out DataType);
						if( o == null || (o is System.DBNull) )
							iCount --;
					}
				}
			}
			return iCount;
		}



		public Object GetAggregateValue(string DataMember, string ColumnName, AggType aggType, bool ignoreNullValues)
		{
			Object o = null;
			switch(aggType)
			{
				case AggType.aggAvg:
					o = Convert.ToDouble(GetTotalOrAvgForField(DataMember, ColumnName, true, ignoreNullValues));
					break;
				case AggType.aggSum:
					o = Convert.ToDouble(GetTotalOrAvgForField(DataMember, ColumnName, false, ignoreNullValues));
					break;
				case AggType.aggCount:
					o = AggCount(DataMember, ColumnName, ignoreNullValues);
					break;
				case AggType.aggMin:
					o = GetMinForField(DataMember, ColumnName, ignoreNullValues);
					break;
				case AggType.aggMax:
					o = GetMaxForField(DataMember, ColumnName, ignoreNullValues);
					break;
			}
			return o;
		}
		#endregion

 	}
	#endregion PageStateManager

	#region EcoPageStateManagerCollection
   public class EcoPageStateManagerCollection : ArrayList
   {
		public int Add(PageStateManager o)
		{
      	if( base.IndexOf(o) < 0 )
				return base.Add(o);
         return -1;
		}
		public new EcoPageStateManager this[int index]
		{
			get
			{
				return base[index] as EcoPageStateManager;
			}
			set
			{
				base[index] = value as EcoPageStateManager;
			}
		}
      public EcoPageStateManager FindPageStateManager(Page page)
      {
      	for( int i = 0; i < this.Count; i++ )
         	if(this[i].CheckPage(page))
            	return this[i];
         return null;
      }
   }
   #endregion EcoPageStateManagerCollection

}


